/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.lspeed;

import ibm.nways.jdm.eui.PropertyBook;
import ibm.nways.lspeed.LsViewSelectionWidget;
import java.awt.Choice;
import java.util.Vector;

public class LsViewSelectionChoiceWidget
extends Choice
implements LsViewSelectionWidget {
    private Vector objectList = new Vector();

    public LsViewSelectionChoiceWidget() {
        this.setBackground(PropertyBook.selListBackColor);
        this.setForeground(PropertyBook.selListForeColor);
    }

    public Integer getKeyForIndex(int n) {
        LsViewObject lsViewObject = (LsViewObject)this.objectList.elementAt(n);
        return lsViewObject.getKey();
    }

    public void addSelection(Integer n, String string) {
        LsViewObject lsViewObject = new LsViewObject(n, string);
        this.objectList.addElement(lsViewObject);
        this.add(lsViewObject.getDescription());
        this.invalidate();
    }

    public void removeSelection(Integer n) {
        int n2 = 0;
        while (n2 < this.objectList.size()) {
            LsViewObject lsViewObject = (LsViewObject)this.objectList.elementAt(n2);
            if (lsViewObject.getKey().intValue() == n.intValue()) {
                this.objectList.removeElement(lsViewObject);
                this.remove(lsViewObject.getDescription());
                return;
            }
            ++n2;
        }
    }

    public void selectView(Integer n) {
        int n2 = 0;
        while (n2 < this.objectList.size()) {
            LsViewObject lsViewObject = (LsViewObject)this.objectList.elementAt(n2);
            if (lsViewObject.getKey().intValue() == n.intValue()) {
                this.select(n2);
                return;
            }
            ++n2;
        }
    }

    public void removeAll() {
        this.objectList.removeAllElements();
        super.removeAll();
    }

    public Object getValue() {
        return this.getKeyForIndex(this.getSelectedIndex());
    }

    public String toString() {
        return this.getValue().toString();
    }

    public void setValue(Object object) {
        if (object instanceof Integer) {
            this.selectView((Integer)object);
        }
    }

    public void setValue(String string) {
        Integer n = new Integer(string);
        this.setValue(n);
    }

    public boolean isValidValue() {
        return this.getKeyForIndex(this.getSelectedIndex()) != null;
    }

    public boolean ignoreValue() {
        return false;
    }

    private class LsViewObject {
        Integer key;
        String description;

        LsViewObject(Integer n, String string) {
            LsViewSelectionChoiceWidget.this = LsViewSelectionChoiceWidget.this;
            this.key = n;
            if (string == null) {
                this.description = n.toString();
                return;
            }
            this.description = string;
        }

        Integer getKey() {
            return this.key;
        }

        String getDescription() {
            return this.description;
        }
    }
}

